dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 2, 220, 220, "assets/images/table/island_2", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 2, 2, 380, 220, "assets/images/table/island_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 8, 200, 350, "assets/images/table/island_8", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 4, 4, 280, 485, "assets/images/table/island", "assets/images/food/item_mark4", "R" );


useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 1;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(female02);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table2;
guest.likes = {female01};
guest.percentRequestTissue = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 6, 3000);


-- Group 2


guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(7, 9, 28000);

-- Group 3

guest = LManager.GenGuest(female04);
guest.matchType = male03;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.likes = {female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 13, 44000);


-- Group 4

guest = LManager.GenGuest(male02);
guest.matchType = table1;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(14, 15, 100000);

-- Group 5

guest = LManager.GenGuest(female03);
guest.matchType = table4;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 16, 130000);


-- Group 6

guest = LManager.GenGuest(female03);
guest.matchType = table3;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(17, 21, 150000);

-- Group 7

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table1;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(22, 23, 170000);

-- Group 8

guest = LManager.GenGuest(male03);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(24, 24, 180000);

LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("bridesmaidsDelay", 95000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 160000 );

LManager:SetLevelSetting ("cakeTipDelay", 70000); 
LManager:SetLevelSetting ("cakeTipChance", 100);


--LManager:AddReseatingRequestForGuest( 50000, aunt );
--LManager:AddReseatingRequestForGuest( 100000, female04 );
--LManager:AddReseatingRequestForGuest( 180000, male03 );

-- Set up the Level Settings
LManager:SetLevelNumber(4,4);
LManager:SetLevelScores(10500, 15000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_2.ogg","assets/audio/music/new_dance_4.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );